
jQuery(document).ready(function($) {

    // Function to update button text and click behavior
    function updateButtonText() {
        let basePrice = 79;
        let addonPrice = 0;
        let redirectUrl = "https://buy.stripe.com/test_4gwcPyb4H2125ckcMO"; // Default URL for basic plan

        // Check if enhanced plan is selected
        if ($('#enhanced-plan').is(':checked')) {
            // Check if planone checkbox is selected
            if ($('input[name="planone[]"]').is(':checked')) {
                addonPrice += 10;
                redirectUrl = "https://buy.stripe.com/test_fZebLudcPgVW9sAaEH"; // Redirect URL for PAY $89
            }
            // Check if plantwo checkbox is selected
            if ($('input[name="plantwo[]"]').is(':checked')) {
                addonPrice += 10;
                redirectUrl = "https://buy.stripe.com/test_6oE9Dm4Gj9tu9sA9AB"; // Redirect URL for PAY $99
            }
        }

        let totalPrice = basePrice + addonPrice;
        $('#submit-btn').text('PAY $' + totalPrice);

        // Update click event of submit button to redirect to the appropriate URL
        $('#submit-btn').off('click').on('click', function(e) {
            e.preventDefault(); // Prevent default form submission
            if ($('#basic-plan').is(':checked') || $('#enhanced-plan').is(':checked')) {
                window.location.href = redirectUrl; // Redirect to the calculated URL
            } else {
                alert("Please select a billing plan."); // Display error message if no plan is selected
            }
        });
    }

    // Event handler for billing plan radio buttons
    $('input[name="billing-plan"]').change(function() {
        if (this.id === 'basic-plan') {
            $('#submit-btn').text('PAY $79'); // Change button text for basic plan
            $('#submit-btn').off('click').on('click', function(e) {
                e.preventDefault(); // Prevent default form submission
                window.location.href = "https://buy.stripe.com/test_4gwcPyb4H2125ckcMO"; // Redirect to basic plan URL
            });
        } else {
            updateButtonText(); // Update button text and behavior for enhanced plan
        }
    });

    // Event handler for planone and plantwo checkboxes
    $('input[name="planone[]"], input[name="plantwo[]"]').change(function() {
        updateButtonText(); // Update button text and behavior whenever checkboxes change
    });

    // Initialize button click event for the default state (basic plan)
    $('#submit-btn').on('click', function(e) {
        e.preventDefault(); // Prevent default form submission
        if ($('#basic-plan').is(':checked') || $('#enhanced-plan').is(':checked')) {
            // Check if any plan is selected
            updateButtonText(); // Update button text and behavior
        } else {
            alert("Please select a billing plan."); // Display error message if no plan is selected
        }
    });
});
jQuery(document).ready(function($) {

    // Function to check if all required fields are filled
    function validateForm() {
        // Check Service Address fields
        var streetAddress = $('.text-228').val().trim();
        var city = $('.city .text-189').val().trim();
        var state = $('.state select').val();
        var zipcode = $('.zipcode .text-260').val().trim();

        // Check Property Details fields
        var locationOfCans = $('.locationofcans').val().trim();
        var startServiceDate = $('.start-service').val().trim();

        // Check Billing Details fields
        var firstName = $('.first .text-228').val().trim();
        var lastName = $('.last .text-228').val().trim();
        var billingCity = $('.billing-address .city .text-189').val().trim();
        var billingState = $('.billing-address .state select').val();
        var billingZipcode = $('.billing-address .zipcode .text-260').val().trim();
        var emailAddress = $('.email').val().trim();
        var phoneNumber = $('.phone-number').val().trim();

        // Validate that all required fields are filled
        if (streetAddress !== '' && city !== '' && state !== '' && zipcode !== ''
            && locationOfCans !== '' && startServiceDate !== ''
            && firstName !== '' && lastName !== '' && billingCity !== '' && billingState !== '' && billingZipcode !== ''
            && emailAddress !== '' && phoneNumber !== '') {
            $('#submit-btn').prop('disabled', false); // Enable submit button
        } else {
            $('#submit-btn').prop('disabled', true); // Disable submit button
        }
    }

    // Call validateForm function on page load
    validateForm();

    // Event listener for input fields to validate form
    $('.form-container input, .form-container select, .form-container textarea').on('input', function() {
        validateForm(); // Call validateForm whenever input changes
    });

    // Event listener for submit button click
    $('#submit-btn').on('click', function(e) {
        // Prevent form submission if button is disabled
        if ($(this).prop('disabled')) {
            e.preventDefault();
            alert('Please fill out all required fields before submitting.');
        }
    });
});

